/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.history;

import filenet.vw.api.VWParticipantHistory;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWStepWorkObjectHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.history.VWParticipantHistoryRowItem;
import java.text.DateFormat;
import java.util.Vector;

public class VWStepHistoryRowItem {
    private Vector<VWParticipantHistoryRowItem> m_rowData = null;
    private boolean m_bExpanded = true;
    private VWParticipantHistoryRowItem m_unexpandedItem = null;

    public VWStepHistoryRowItem(VWStepHistory vwStepHistory, DateFormat dateFormat) {
        this.initData(vwStepHistory, dateFormat);
    }

    public VWParticipantHistoryRowItem getItemAt(int nIndex) {
        VWParticipantHistoryRowItem rowItem = null;
        if (this.m_rowData == null || nIndex < 0 || nIndex > this.m_rowData.size()) {
            return null;
        }
        if (nIndex < this.m_rowData.size()) {
            if (this.isExpandable() && !this.isExpanded() && this.m_unexpandedItem != null) {
                return this.m_unexpandedItem;
            }
            rowItem = this.m_rowData.elementAt(nIndex);
        }
        return rowItem;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public boolean isExpandable() {
        return this.m_rowData != null && this.getRowCount() > 1;
    }

    public boolean isExpanded() {
        if (this.isExpandable()) {
            return this.m_bExpanded;
        }
        return false;
    }

    public void setExpanded(boolean bExpanded) {
        this.m_bExpanded = this.isExpandable() ? bExpanded : false;
    }

    private void initData(VWStepHistory vwStepHistory, DateFormat dateFormat) {
        try {
            this.m_rowData = new Vector();
            this.m_unexpandedItem = null;
            if (vwStepHistory != null) {
                int nOccurrence = 0;
                while (vwStepHistory.hasNext()) {
                    VWStepOccurrenceHistory stepOcc = vwStepHistory.next();
                    if (stepOcc == null) continue;
                    ++nOccurrence;
                    while (stepOcc.hasNext()) {
                        VWStepWorkObjectHistory stepWobHistory = stepOcc.next();
                        if (stepWobHistory == null || !stepWobHistory.getIsCompleted()) continue;
                        while (stepWobHistory.hasNext()) {
                            VWParticipantHistoryRowItem rowItem;
                            VWParticipantHistory participantHistory = stepWobHistory.next();
                            if (participantHistory == null || participantHistory.getStepStatus() != 2 || (rowItem = new VWParticipantHistoryRowItem(vwStepHistory.getStepName(), nOccurrence, participantHistory, dateFormat)) == null) continue;
                            this.m_rowData.addElement(rowItem);
                        }
                    }
                }
                if (this.isExpandable()) {
                    this.m_unexpandedItem = new VWParticipantHistoryRowItem(vwStepHistory.getStepName(), 1, null, null);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

